"""Moduel to interact with the OS"""
import os

from dotenv import find_dotenv, load_dotenv

from errors.errors import EnvironementVariableNotFoundError


class AppConfig:
    """Class to set up the configuration of the app"""

    def __init__(self) -> None:
        load_dotenv(find_dotenv())

    def get(self, name):
        """Return the specified environment variable or raise EnvironementVariableNotFoundError if the variable doesn't exists"""
        var = os.getenv(name)

        if not var:
            raise EnvironementVariableNotFoundError()

        return var
