#Template latex

Created in 2013 by **Nicolas Jakob** (nicolas.jakob@master.hes-so.ch)

Updated in 2019 by **Joao Manuel Pereira Mendes** (joaomanuel-pereiramendes@master.hes-so.ch)

__Feel free to update this template to your needs__

[Set environment](https://www.latex-project.org/get/)

##### Structure

###### report.tex

Entry point of your report, only file you need to compile.
 
###### mse.sty

MSE package who contains package usage and configuration. Also it contains title page and extra info design. 

###### bibliography.bib

Contains all your references.

###### gfx/

Directory who put your graphic files.

###### chapters/

Directory who put your chapters.

###### appendices/

Directory who put your appendices.

#### Usage

##### Report type

This template is preconfigured with 2 types _semester_ and _master_ use the one you need.

###### Semester's project

```latex
\documentclass[12pt,a4paper,twoside,titlepage]{report}

\usepackage[semester, tin]{mse}
```

###### Master's project

```latex
\documentclass[12pt,a4paper,twoside,titlepage]{report}

\usepackage[master, tin]{mse}
```

##### Confidential work

If your work is confidential, set parameter confidential it will automatically place a confidential annotation in title 
page.

```latex
\usepackage[semester, confidential]{mse}
```
or

```latex
\usepackage[master, confidential]{mse}
```

##### Orientation

This template is preconfigured with 2 orientations, _tin_ & _tic_.

```latex
\usepackage[semester, tic]{mse}
```
or

```latex
\usepackage[semester, tin]{mse}
```

##### Multiple arguments

All arguments can be used at the same type except _semester_ with _master_ and _tin_ with _tic_.

```latex
\usepackage[semester, tin, confidential]{mse}
```

##### Exchange work

If your project is part of an exchange with another institute use parameter exchange to display in title page the 
exchange data. You will need to provide some values, wich is described later in this file.

```latex
\usepackage[semester, exchange]{mse}
```
or

```latex
\usepackage[semester, exchange]{mse}
```



#### Values usage

You can define a set of values who can be used along your report.

##### Project info

```latex
\title{\LaTeX\ Thesis Template} % Title of the project
```

##### Author info

```latex
\author{Nicolas Jakob} % Author of the document
\email{nicolas.jakob@master.hes-so.ch} % Email of the author
\location{Lausanne} % Location of the Author
```

##### Exchange info

Remove this line if your project is no an exchange.

```latex
\exchange{Soutenu par le laboratoire/école de (nom du laboratoire/autres)}{à (endroit, Institution)}{Sous la supervision de (nom, titre (Prof, Dr, position))}
```

##### Professors info

```latex
\advisor{Prof. Conseiller} % Advisor of the project
\head{Prof. Responsable} % MRU of your institute

\professor{Prof. Professeur}{professeur@heig-vd.ch}{HEIG-VD}{Haute école d'ingénierie et de gestion du canton de Vaud}
\supervisor{Prof. Supervieur}{superviseur@heig-vd.ch}{HEIG-VD}{Haute école d'ingénierie et de gestion du canton de Vaud}
\proposedby{\@professor}{\@professoremail}{\@professorinstitute}{\@professorinstitutefull}

\institute{Dans la \@professorinstitutefull}
```

##### Experts info

Remove \externalexpert if no external expert have been necessary. 

```latex
\externalexpert{Prof. Expert Externe}{expert.externe@master.hes-so.ch}{Haute école spécialisée de Suisse occidentale}{HES-SO}

\expert{Prof. Expert}{expert@master.hes-so.ch}{Haute école spécialisée de Suisse occidentale}{HES-SO}
```

#### Packages

This section describe how to use some packages

##### Acronym

This package allows you to define the acronym definition and display it properly. It is imported in _mse.sty_ and 
by default it display a foot note and only show acronym used. To define an acronym check _appendices/acronyms.tex_ for 
examples.

```latex

\ac{AWS} % Usage of acronym in your document

```

##### Minted

This package allows you to display code samples with syntax highlighting. It is imported in _mse.sty_ and by default it 
uses _tango_ style. For more details check [Minted - Reference guide](https://fr.overleaf.com/learn/latex/Code_Highlighting_with_minted#Reference_guide).
You may need to install __python-pygments__.

##### Missing packages 

If you need a package who is not imported add it to _report.tex_ after
 
```latex
\usepackage[semester, tic, confidential]{mse}
```
