# MCP2221A libraries

Support for user space usage of the [MCP2221A][1] IC from Microchip. 

## Linux

To access the USB HID device you must add the following rule under */etc/udev/rules.d/* (i.e in a file called 99-mcp2221a.rules) :

```bash
SUBSYSTEM=="usb", ATTRS{idVendor}=="04d8", ATTRS{idProduct}=="00dd", GROUP="plugdev", TAG+="uaccess"
```

Then update *udev* with the following commands:

```bash
sudo udevadm control --reload
sudo udevadm trigger
```

To access the I2C devices loaded by the [*mcp2221*][2] kernel driver you must add your user to the *i2c* group:

```bash
sudo usermod -aG i2c $USER
```

You must login again in order for the changes to take effect.

To access the Serial device you must add your user to the *dialout* group:

```bash
sudo usermod -aG dialout $USER
```

You must login again in order for the changes to take effect.

## Windows 

Nothing to configure the Microchip *dll* contains all the configuration necessary.

## Build

Standard **CMAKE**:

For Linux:

```bash
cmake --preset linux
cmake --build build/
```

For Windows:

```bash
cmake --preset windows
cmake --build build --config Release
```

## Try it out

Run the test software found in the tests folder. Expected result is:

```bash
./build/tests/test

Testing serial (115200, 1s): Success
Testing serial (9600, 1s): Success
Testing serial (9600, 0.1s): Success
Testing I2C: Success
```

## TODO

- [ ] Add python library 
- [X] Add Windows support
- [ ] Add hidapi support

[1]:http://ww1.microchip.com/downloads/en/devicedoc/20005565b.pdf
[2]:https://github.com/torvalds/linux/blob/master/drivers/hid/hid-mcp2221.c