#include <stdexcept>
#include <cstdint>

namespace MCP2221A {

    class HIDException : public std::exception {
        private:

        std::string msg_;

        public:

        HIDException(std::string msg) : msg_(msg) {}

        virtual const char* what() const throw()
        {
            return msg_.c_str();
        }
    };

    union status{
        uint8_t raw[64];
        struct {
            uint8_t cmd_echo;
            uint8_t success;
            uint8_t cancel_transfer;
            uint8_t i2c_speed_set;
            uint8_t i2c_divider;
            uint8_t unused_0[3];
            uint8_t i2c_state;
            uint8_t i2c_lsb_transfer_len;
            uint8_t i2c_msb_transfer_len;
            uint8_t i2c_lsb_already_transferred_len;
            uint8_t i2c_msb_already_transferred_len;
            uint8_t i2c_data_buffer_counter;
            uint8_t i2c_current_divider;
            uint8_t i2c_current_timeout;
            uint8_t lsb_i2c_address;
            uint8_t msb_i2c_address;
            uint8_t unused_1[2];
            union {
                uint8_t raw;
                struct {
                    uint8_t :1;
                    uint8_t ack;
                    uint8_t :6;
                };
            }ack_status;
            uint8_t unused_2[1];
            uint8_t scl_line_value;
            uint8_t sda_line_value;
            uint8_t int_edge_detect_state;
            uint8_t i2c_read_pending;
            uint8_t unused_3[18];
            uint8_t hardware_revision_major;
            uint8_t hardware_revision_minor;
            uint8_t firmware_revision_major;
            uint8_t firmware_revision_minor;
            uint8_t adc_data[6];
            uint8_t unused_4[8];
        };
    };
    
    extern void hid_set_i2c_speed(unsigned int speed);
    extern void hid_get_status(status& stat);

}