import serial

class MCP2221ASerial:

    def __init__(self, port : str = "/dev/ttyACM0", baud: int = 115200):
        self.ser = None
        self.ser = serial.Serial(port, baud, timeout=1)

    def __del__(self):
        if self.ser is not None:
            self.ser.close()

    def write(self, data: bytearray):

        bytes = self.ser.write(data)
        if bytes < len(data):
            print("Failed to send")

    def read(self, size : int = 1) -> bytearray:

        data = self.ser.read(size)
        if len(data) < size:
            print("Failed to read")
        
        return data


if "__main__" == __name__:

    ser = MCP2221ASerial()

    data = b"Hello World!"
    ser.write(data)
    recv = ser.read(len(data))
    print(recv.decode())