#include <iostream>

#include "mcp2221a_hid.h"


int main()
{
    int ret = 0;

    try {
        MCP2221A::status stat;
        MCP2221A::hid_get_status(stat);

        std::cout << "Frimware Version: " << (char)stat.firmware_revision_major << "." << (char)stat.firmware_revision_minor << std::endl;
    } catch (const MCP2221A::HIDException& e) {
        std::cerr << "HID Exception: " << e.what() << std::endl;
        return -1;
    }

    try {
        MCP2221A::hid_set_i2c_speed(400000);
    } catch (const MCP2221A::HIDException& e) {
        std::cerr << "HID Exception: " << e.what() << std::endl;
        return -1;
    }

    std::cout << "I2C speed set to 400kHz successfully." << std::endl;

    return 0;
}