#include <iostream>
#include <memory>
#include "mcp2221a.h"

using namespace std;

int main()
{
    std::unique_ptr<MCP2221A::I2CMaster> i2c;

    try {
        i2c = std::make_unique<MCP2221A::I2CMaster>();
    } catch (const MCP2221A::I2CMasterException& e) {
        cerr << e.what() << endl;
        return -1;
    }

    try {
        i2c->set_speed(I2C_SPEED_100KHZ);
    } catch (const MCP2221A::I2CMasterException& e) {
        cerr << "I2C Master Exception: " << e.what() << endl;
        return -1;
    }

    cout << "Scanning I2C bus..." << endl;

    try {
        vector<int> slaves = i2c->get_slaves_addresses(true);
        if (slaves.empty()) {
            cout << "No slave found" << endl;
            return 0;
        }
    
        for (auto& slave: slaves)
            cout << hex << "0x" << slave << dec << endl;
    
        return 0;
    } catch (const MCP2221A::I2CMasterException& e) {
        cerr << "I2C Master Exception: " << e.what() << endl;
        return -1;
    }

    return 0;
}