#include <iostream>
#include <thread>
#include <chrono>

#include "mcp2221a.h"

int main()
{
    std::unique_ptr<MCP2221A::Serial> serial;

    try {
        serial = std::make_unique<MCP2221A::Serial>();
    } catch (const MCP2221A::SerialException& e) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    std::cout << "MCP2221A Serial port opened successfully!" << std::endl;

    // Use the serial port for communication
    uint8_t data_to_send[] = {0x48, 0x65, 0x6C, 0x6C, 0x6F}; // "Hello"
    try {
        serial->send(data_to_send, sizeof(data_to_send));
    } catch (const MCP2221A::SerialException& e) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    std::cout << "Data sent successfully!" << std::endl;
    std::this_thread::sleep_for(std::chrono::milliseconds(100));

    uint8_t data_to_receive[5];
    try {
        serial->receive(data_to_receive, sizeof(data_to_receive));
    } catch (const MCP2221A::SerialException& e) {
        std::cerr << e.what() << std::endl;
        return -1;
    }

    std::cout << "Data received successfully: " << std::string(data_to_receive, data_to_receive + sizeof(data_to_receive)) << std::endl;

    return 0;
}