# MS210 python driver

This repository contains a small python module to control the MS210 Channel Mixer by Advanced Illumination

> **NOTE**:
> 
> For linux user add your user to the *dialout* group to access the serial port
>
> ```bash
> sudo usermod -aG dialout $USER
> ```

## Dependencies

| Name | Version |
|------|---------|
| Python | >= 3.10 |
| Poetry | >= 1.2.0 |

Install python dependencies:

```bash
poetry install
```

## App

A QT based graphical interface to control the **MS210** is available and can be run with the following command:

```bash
poetry run controller
```

![UI](img/ms210_ui.png)

## Add the MS210 package

Instructions to add the MS210 package to your project

### Poetry

Add a secondary source to your poetry project

```bash
poetry source add -s igib https://labinfo.ing.he-arc.ch/gitlab/api/v4/projects/2417/packages/pypi/simple
```

Add **ms210** package

```bash
poetry add ms210 --source igib
```

### PIP

```bash
pip install pyrsvp --index-url https://labinfo.ing.he-arc.ch/gitlab/api/v4/projects/2417/packages/pypi/simple/
```

## Usage

```python
dev = MS210("/dev/ttyUSB0")

# Set the red value
success, msg = dev.set_value("R", 500)
if not success:
    print(msg)

# Get the green value
green = dev.get_value("G")
print(green)
```