# Zephyr Raspberry Pi Pico

This repo contains Zephyr OS for Raspberry Pi Pico.

## Tools

Use **apt** to install the required dependencies:

```bash
sudo apt-get install --no-install-recommends -y git cmake ninja-build gperf tar
ccache dfu-util device-tree-compiler wget python3-dev python3-pip python3-setuptools python3-tk
python3-wheel xz-utils file make gcc gcc-multilib g++-multilib libsdl2-dev libmagic1 python3-venv
automake autoconf build-essential texinfo libtool libftdi-dev libusb-1.0-0-dev pkg-config
```

### West

> West (Zephyr’s meta-tool)
> The Zephyr project includes a swiss-army knife command line tool named west. West is developed in its own repository.

More info about [**WEST**][1]
 
Run the *initzephyr.sh* script found in the *zephyrproject* folder:

```bash
cd zephyrproject
./initzephyr.sh
```

This script will create a new python virtual environnement under *.venv* and install all the necessary packages. It will the 
install *Zephyr* and it's dependencies.

### OpenOCD

OpenOCD is used to flash and debug the a *Zephyr* application. Clone the OpenOCD repo on your host machine 

```bash
cd ~
git clone https://github.com/raspberrypi/openocd.git --branch rp2040-v0.12.0 --depth=1 --no-single-branch
```

Configure, build and install OCD

```bash
cd openocd
./bootstrap
./configure
make -j4
sudo make install
```

Check the OCD version

```bash
openocd --version
```

Output:

```bash
Open On-Chip Debugger 0.12.0-g4d87f6d (2024-01-08-14:31)
Licensed under GNU GPL v2
For bug reports, read
        http://openocd.org/doc/doxygen/bugs.html
```

Create a file with any name (ex. pico_openocd.rules) under /etc/udev/rules.d and put this line inside.

```bash
ATTRS{idVendor}=="2e8a", ATTRS{idProduct}=="000c", MODE="660", GROUP="plugdev", TAG+="uaccess"
```

To uninstall OCD run

```bash
sudo make uninstall
```

## Build a project

To build a project you can use **West** or the *build.sh* script. 

> :warning: When using **West** directly you must activate the Python virtual environnement: ```source .venv/bin/activate```

The build script take the following arguments:

```bash
Build zephyr project

Syntax: ./build.sh [-b|c|d|f|h|] <args>
[ -b PATH ]   Build project. Path to project folder
[ -c ]        Clean
[ -d ]        Launch debugger
[ -f ]        Flash board
[ -h ]        Help
```

We will build a simple *blinky* example:

```bash
./build.sh -b zephyr/samples/basic/blinky
```

The compilation output will be in the *build* folder.

## Hardware connection

![Pico debug connection](img/pico_debug_wiring.png)

## Flash the app

To flash the application code run the following:

```bash
./build.sh -f
```

You should now see the LED blinking.

## Debug

Install *gdb-multiarch*

```bash
sudo apt install gdb-multiarch
```

Create a *launch.json* configuration file in VSCode and copy the following:

```json
{
    "version": "0.2.0",
    "configurations": [
        {
            "name": "Pico Debug",
            "type":"cortex-debug",
            "cwd": "${workspaceRoot}",
            "executable": "${workspaceFolder}/zephyrproject/build/zephyr/zephyr.elf",
            "request": "launch",
            "servertype": "external",
            // This may need to be arm-none-eabi-gdb depending on your system
            "gdbPath" : "gdb-multiarch",
            // Connect to an already running OpenOCD instance
            "gdbTarget": "localhost:3333",
            "svdFile": "${env:PICO_SDK_PATH}/src/rp2040/hardware_regs/rp2040.svd",
            "runToEntryPoint":"main",
            // Work around for stopping at main on restart
            "postRestartCommands": [
                "break main",
                "continue"
            ]
        }
    ]
}
```

Install the following extension in VSCode

- Cortex-Debug
- Cmake-tools
- C/C++

Run the board in debug mode:

```bash
./build.sh -d
```

Now run the debugger in VScode

[1]:https://docs.zephyrproject.org/latest/develop/west/index.html