#!/bin/bash

SCRIPTPATH="$( cd "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"
CEXE="test"
CPPEXE="testpp"

run_valgrind()
{
    valgrind --leak-check=full \
            --show-leak-kinds=all \
            --track-origins=yes \
            --log-file=$1-valgrind-out.txt \
            ./$1
}

cmake --build build/debug
cmake --build build/release

cd $SCRIPTPATH/build/debug/tests
run_valgrind $CEXE
run_valgrind $CPPEXE

cd $SCRIPTPATH/build/release/tests
run_valgrind $CEXE
run_valgrind $CPPEXE
