#include <stdio.h>
#include <stdlib.h>

int count_char_in_int(int value)
{
    // Take into account the sign
    int chars = value < 0 ? 1 : 0;
    int modulo = 0;

    if (value == 0)
        return 1;
    
    value = abs(value);

    while (value > 0) {
        modulo = value % 10;

        if (modulo == 0)
            value /= 10;
        else
            value = (value - modulo) / 10;
        
        chars++;
    }

    return chars;
}

int count_chars_in_double(double value, int precision)
{  
    // Start at precision. Plus one to account for the dot
    int chars = precision + 1;
    int int_value = (int)value;

    // Account for negative 0
    if (value > -1.0 && value < 0.0)
        chars += 1;

    return count_char_in_int(int_value) + chars;
}

int main()
{
    int val = 11111111;
    double val1 = -1.87844189641134813;

    printf("Val: %d, chars: %d\n", val, count_char_in_int(val));
    printf("Val: %.5f, chars: %d\n", val1, count_chars_in_double(val1, 5));

    return 0;
}