#include <stdlib.h>
#include <stdio.h>
#include <string.h>
// #include "gtest/gtest.h"

extern "C" {
#include "rsvp.h"
}

#define TEST_DATA "START;S(STR)=PASS"

// TEST(ParseTest, DataToStringConversion) 
// {
//     char input[] = "START;S(STR)=PASS;TEXT(VECS)=LINE1\tLINE2;VECD=[X=1.0,Y=2.0,Z=3.0]";

//     rsvp_data_t* data = rsvp_data_parse(input);
//     char *str = rsvp_data_to_string(data, 5);
//     EXPECT_STREQ(str, input);

//     free(str);
//     rsvp_data_free(data);
// }

// TEST(BuildTest, BuildDataFromScratch)
// {
//     rsvp_data_t* data = rsvp_data_create("START");
//     rsvp_data_add_var(data, rsvp_var_create_string("S", "PASS"));
//     EXPECT_STREQ(TEST_DATA, rsvp_data_to_string(data, 5));

//     rsvp_data_free(data);
// }

int main()
{
    char test_str[] = "START;STATUS(STR)=PASS;T(DBL)=4.50000;COUNT(INT)=3;USER(STR)=JEAN;FOUND(BOOL)=FALSE;POS(VECD)=[X=1.00000,Y=2.00000,Z=3.00000];TEXT(VECS)=LINE1\tLINE2";
    rsvp_data_t* data = rsvp_data_parse(test_str);
    char *str = rsvp_data_to_string(data, 5);

    if (strcmp(test_str, str) != 0) {
        printf("String don't match\n");
    }

    if (strlen(test_str) != strlen(str)) {
        printf("String don't have the same length\n");
    }

    printf("%s\n%s\n", test_str, str);

    free(str);
    rsvp_data_free(data);
}