#include <string>
#include <iostream>

#include "rsvppp.h"

using namespace std;

int main()
{
    string test_str("START;STATUS=PASS;T(DBL)=4.5;COUNT(INT)=3;USER(STR)=JEAN;FOUND(BOOL)=FALSE;POS(VECD)=[X=1.0,Y=2.0,Z=3.0];TEXT(VECS)=LINE1\tLINE2");

    RSVP::Packet pkt = RSVP::Packet::parse_data(test_str);
    cout << pkt.to_string() << endl;

    RSVP::Packet pkt1 = RSVP::Packet("START1");
    pkt1.add_arg("T", 4.5);
    pkt1.add_arg("COUNT", 3);
    pkt1.add_arg("VECD", vector<tuple<string, double>>{{"X", 1.0}, {"Y", 2.0}});
    cout << pkt1.to_string() << endl;

    RSVP::Packet pkt2 = RSVP::Packet::parse_data(pkt1.to_string());
    cout << pkt2.to_string() << endl;

    return 0;
}