#!/bin/bash

SCRIPTPATH="$( cd "$(dirname "$0")" >/dev/null 2>&1 ; pwd -P )"

cd $SCRIPTPATH

UI_FILES=`(find ui/ -type f -iname "*.ui")`

# Generate qt designer files
for f in ${UI_FILES}; do
    echo $f > .tmp
    sed -i "s/.ui/.py/g" .tmp

    PYHTON_FILE=`(cat .tmp)`
    echo "$PYHTON_FILE $f"

    rm .tmp

    poetry run pyside6-uic -o $PYHTON_FILE $f
done