#include <Arduino.h>
#include <TMC5160.h>

#define DBG Serial1

enum ROTATION_AXIS{
    RZ = 0,
    RY,
    RZ1
};

// axis 1
const uint8_t SPI_CS1 = 10; // CS pin in SPI mode
// axis 2
const uint8_t SPI_CS2 = 9; // CS pin in SPI mode
// axis 3
const uint8_t SPI_CS3 = 8; // CS pin in SPI mode

const uint8_t SPI_DRV_ENN = 22;  // DRV_ENN pin in SPI mode

TMC5160_SPI motor1 = TMC5160_SPI(SPI_CS1); // Use default SPI peripheral and SPI settings
TMC5160_SPI motor2 = TMC5160_SPI(SPI_CS2); // Use default SPI peripheral and SPI settings
TMC5160_SPI motor3 = TMC5160_SPI(SPI_CS3); // Use default SPI peripheral and SPI settings


void setup()
{
	// USB/debug serial coms
	Serial.begin(115200);
	DBG.begin(115200);
	delayMicroseconds(10);

	pinMode(SPI_DRV_ENN, OUTPUT);
	digitalWrite(SPI_DRV_ENN, LOW); // Active low

	// This sets the motor & driver parameters /!\ run the configWizard for your driver and motor for fine tuning !
	TMC5160::PowerStageParameters powerStageParams1; // defaults.
	TMC5160::MotorParameters motorParams1;
	motorParams1.globalScaler = 100; // max 180 Adapt to your driver and motor (check TMC5160 datasheet - "Selecting sense resistors")
	motorParams1.irun = 31;
	motorParams1.ihold = 10;
	// This sets the motor & driver parameters /!\ run the configWizard for your driver and motor for fine tuning !
	TMC5160::PowerStageParameters powerStageParams2; // defaults.
	TMC5160::MotorParameters motorParams2;
	motorParams2.globalScaler = 100; // max 180 Adapt to your driver and motor (check TMC5160 datasheet - "Selecting sense resistors")
	motorParams2.irun = 31;
	motorParams2.ihold = 10;
	// This sets the motor & driver parameters /!\ run the configWizard for your driver and motor for fine tuning !
	TMC5160::PowerStageParameters powerStageParams3; // defaults.
	TMC5160::MotorParameters motorParams3;
	motorParams3.globalScaler = 100; // max 180 Adapt to your driver and motor (check TMC5160 datasheet - "Selecting sense resistors")
	motorParams3.irun = 31;
	motorParams3.ihold = 10;

	SPI.begin();
	motor1.begin(powerStageParams1, motorParams1, TMC5160::NORMAL_MOTOR_DIRECTION);
	motor2.begin(powerStageParams2, motorParams2, TMC5160::NORMAL_MOTOR_DIRECTION);
	motor3.begin(powerStageParams3, motorParams3, TMC5160::NORMAL_MOTOR_DIRECTION);

	// ramp definition
	motor1.setRampMode(TMC5160::POSITIONING_MODE);
	motor2.setRampMode(TMC5160::POSITIONING_MODE);
	motor3.setRampMode(TMC5160::POSITIONING_MODE);

	motor1.setMaxSpeed(30);
	motor1.setAcceleration(200);
	motor2.setMaxSpeed(30);
	motor2.setAcceleration(200);
	motor3.setMaxSpeed(30);
	motor3.setAcceleration(200);

	delay(1000); // Standstill for automatic tuning

    // Wait acknowledge
    while(!Serial.available()) {
		Serial.println("Wait");
		DBG.println("Remove standstill");
		delay(250);
	}

	Serial.clear();
	// delay(10000); // Standstill to remove the Support Blocks

	//----------------------------------Move to the Home-----------------------

	//------------------------------End of Move to the Home--------------------
	DBG.println("starting up");
	int k = 5;
	motor1.setMaxSpeed(15 * k);
	motor1.setAcceleration(30 * k);
	motor2.setMaxSpeed(15 * k);
	motor2.setAcceleration(30 * k);
	motor3.setMaxSpeed(15 * k);
	motor3.setAcceleration(30 * k);
	delay(1000);
	Serial.println("Ready");
}

bool parse_data(String data, float* values)
{
	bool ret = true;
	int count = 0;
	// data.indexOf()

	while (count < 3) {
		int index = data.indexOf(",");
		values[count++] = data.substring(0, index).toFloat();
		data = data.substring(index + 1);
	}

	return ret;
}

void loop()
{

	float new_pos[3] = {0.0};

	if (Serial.available()) {
		String data = Serial.readStringUntil('\n');
		if (!parse_data(data, new_pos)) {
			goto send_current_pos;
		}

		DBG.printf("New pos: %f, %f, %f", new_pos[ROTATION_AXIS::RZ], new_pos[ROTATION_AXIS::RY], new_pos[ROTATION_AXIS::RZ1]);
		DBG.println();

		motor1.setTargetPosition(new_pos[ROTATION_AXIS::RZ]);
		motor2.setTargetPosition(new_pos[ROTATION_AXIS::RY]);
		motor3.setTargetPosition(new_pos[ROTATION_AXIS::RZ1]);
	}

    

send_current_pos:

	float current_pos[3] = {
		motor1.getCurrentPosition(),
		motor2.getCurrentPosition(),
		motor3.getCurrentPosition()
	};

	// DBG.printf("Current pos: %f, %f, %f", current_pos[ROTATION_AXIS::RZ], current_pos[ROTATION_AXIS::RY], current_pos[ROTATION_AXIS::RZ1]);
	// DBG.println();

	Serial.printf("%f,%f,%f", current_pos[ROTATION_AXIS::RZ], current_pos[ROTATION_AXIS::RY], current_pos[ROTATION_AXIS::RZ1]);
	Serial.println();

	delay(10);
}
