
/*
 * \file
 *         A very simple Contiki application
 * \author
 *         NUP, FSA
 */

#include "contiki.h"
#include "dev/button-sensor.h"
#include "dev/leds.h"

#include <stdio.h> 
#ifdef LEDS_ALL
  #undef LEDS_ALL
#endif
#define LEDS_ALL LEDS_GREEN|LEDS_RED|LEDS_BLUE
/*---------------------------------------------------------------------------*/
PROCESS(AppBlinkButton_process, "AppBlinkButton process");
AUTOSTART_PROCESSES(&AppBlinkButton_process);
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(AppBlinkButton_process, ev, data)
{
  static int counter = 0;
  PROCESS_BEGIN();

  SENSORS_ACTIVATE(button_sensor); //Pour activer les bouttons
  leds_init();

  leds_on(LEDS_ALL);
  printf("EX Labo1 appBlinkButton \n");

  while(1) 
  {
      switch (counter)
      {
      case 1:
        leds_on(LEDS_RED);
        counter++;
        printf("RED\n");
        break;
      case 2:
        leds_on(LEDS_GREEN);
        counter++;
         printf("GREEN\n");
        break;
      case 3:
        leds_on(LEDS_BLUE);
         printf("BLUE\n");
        counter=0;
        break;
      case 0:
        leds_off(LEDS_GREEN);
        leds_off(LEDS_RED);
        leds_off(LEDS_BLUE);
        printf("NO LEDS\n");
        counter++;
        break;
      default:
        leds_off(LEDS_GREEN);
        leds_off(LEDS_RED);
        leds_off(LEDS_BLUE);
        printf("NO LEDS\n");
        counter=0;
        break;
      }
    /* Wait for the periodic timer to expire and then restart the timer. */
    PROCESS_WAIT_EVENT_UNTIL((ev == sensors_event) && (data == &button_sensor));
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/
