
/*
 * \file
 *        Application clignotement des leds
 * \author
 *        Joe Leiber
 */

#include "contiki.h"
#include "sys/ctimer.h"
#include "sys/rtimer.h"
#include "dev/leds.h"
#include "dev/button-sensor.h"

#include <stdio.h> 
/*---------------------------------------------------------------------------*/
PROCESS(template_process, "Template process");
AUTOSTART_PROCESSES(&template_process);
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(template_process, ev, data)
{
  static struct ctimer timer;
  static bool stateButton = false;
  static int time=0;

 void callbackc(void *ptr)
  {
    ctimer_reset( &timer);
      if(stateButton == 1)
     {
        leds_toggle(LEDS_GREEN);
        time=clock_seconds();
        printf("%d secondes\n", time);
      }
      else
      {
        time=clock_seconds();
        printf("%d secondes\n", time);
      }	

  }
  PROCESS_BEGIN();

  SENSORS_ACTIVATE(button_sensor);

  /* Setup a periodic timer that expires after 2 seconds. */
  ctimer_set(&timer, CLOCK_SECOND * 1,callbackc,NULL);

  while(1) 
  {
    PROCESS_WAIT_EVENT();

    if ((ev == sensors_event) && (data == &button_sensor))
    {
        stateButton = !stateButton;
        printf("Button = %d\n",stateButton);
    }
  }


  PROCESS_END();
}
/*---------------------------------------------------------------------------*/
