
/*
 * \file
 *        Application clignotement des leds
 * \author
 *        Joe Leiber
 */

#include "contiki.h"
#include "sys/etimer.h"
#include "dev/leds.h"
#include "dev/button-sensor.h"

#include <stdio.h> 
/*---------------------------------------------------------------------------*/
PROCESS(template_process, "Template process");
AUTOSTART_PROCESSES(&template_process);
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(template_process, ev, data)
{
  static struct etimer timer;
  static bool stateButton = false;
  static int time=0;
  PROCESS_BEGIN();

  SENSORS_ACTIVATE(button_sensor);

  /* Setup a periodic timer that expires after 2 seconds. */
  etimer_set(&timer, CLOCK_SECOND * 1);

  while(1) 
  {
    PROCESS_WAIT_EVENT();

    if ((ev == sensors_event) && (data == &button_sensor))
    {
        stateButton = !stateButton;
        printf("Button = %d\n",stateButton);
    }
    else if (etimer_expired(&timer) && (stateButton == 1))
    {
         leds_toggle(LEDS_GREEN);
         time=clock_seconds();
         printf("%d secondes\n", time);	
    }
    else if(etimer_expired(&timer))
    {
       time=clock_seconds();
       printf("%d secondes\n", time);	
    }
    

    /* Wait for the periodic timer to expire and then restart the timer. */
    etimer_reset(&timer);
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/
