
/*
 * \file
 *         A very simple Contiki application
 * \author
 *         NUP, FSA
 */

#include "contiki.h"
#include "dev/button-sensor.h"
#include "dev/leds.h"
#include <stdio.h> 

#ifdef LEDS_ALL
	#undef LEDS_ALL
#endif
#define LEDS_ALL LEDS_GREEN|LEDS_RED|LEDS_YELLOW

static void callback(void *ptr);
static void callbackRealTime(struct rtimer *t, void *ptr);

static struct ctimer timer;
static struct rtimer task;

/*---------------------------------------------------------------------------*/
PROCESS(template_process, "Blink process");
AUTOSTART_PROCESSES(&template_process);
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(template_process, ev, data)
{
  static int fButton=1;

  PROCESS_BEGIN();

  /* Setup a periodic timer that expires after 1 seconds. */
  ctimer_set(&timer, CLOCK_SECOND * 10, callback, NULL);
  
  SENSORS_ACTIVATE(button_sensor);  //Active les évènements sur les boutons

  leds_off(LEDS_ALL);

  while(1)
  {
    printf("Hello \n");
    PROCESS_WAIT_EVENT();
    
    if((ev == sensors_event) && (data == &button_sensor))
    {
    	fButton=!(fButton);
    }
    
    if(fButton == 0)
    {
    	ctimer_stop(&timer);
    }
    else
    {
    	ctimer_restart(&timer);
    }
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/


static void callback(void *ptr)
{
	printf("Callback ctimer\n");
	leds_toggle(LEDS_ALL);
	rtimer_set(&task, RTIMER_NOW() + RTIMER_ARCH_SECOND*2, 1, callbackRealTime, NULL);
	ctimer_reset(&timer);
}

static void callbackRealTime(struct rtimer *t, void *ptr)
{
	printf("Callback Rtimer\n");
	leds_toggle(LEDS_ALL);
}




