
/*
 * \file
 *         A very simple Contiki application
 * \author
 *         NUP, FSA, JOL
 */


#include "contiki.h"
#include "sys/ctimer.h"
#include "sys/rtimer.h"
#include "dev/leds.h"
#include "dev/button-sensor.h"

#include <stdio.h> 


#ifdef LEDS_ALL
	#undef LEDS_ALL
#endif
#define LEDS_ALL LEDS_GREEN|LEDS_RED|LEDS_YELLOW
/*---------------------------------------------------------------------------*/
  static process_event_t event1;
  static process_event_t event2;
PROCESS(main_process, "main process");
PROCESS(toggle_process, "toggle process");
PROCESS(color_process, "color process");
AUTOSTART_PROCESSES(&main_process, &toggle_process, &color_process);

/*---------------------------------------------------------------------------*/
PROCESS_THREAD(main_process, ev, data)
{
  static struct etimer timer;
  static int leds_color=LEDS_YELLOW;

  PROCESS_BEGIN();

  SENSORS_ACTIVATE(button_sensor);
  /* Setup a periodic timer that expires after 10 seconds. */
  etimer_set(&timer, CLOCK_SECOND * 1);

  while(1) 
  {
    
    PROCESS_WAIT_EVENT();

    if ((ev == sensors_event) && (data == &button_sensor))
    {
        //event2 change la couleur de la led
        process_post(&color_process, event2, &leds_color);
        printf("BLINK\n");
    }
    else if (etimer_expired(&timer))
    {
         //event1 change l'état de la led
         process_post(&toggle_process, event1, &leds_color);
         printf("TIMER\n");
         etimer_reset(&timer);
    }

    /* Wait for the periodic timer to expire and then restart the timer. */
    
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/


//                                PROCESS TOGGLE
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(toggle_process, ev, data)
{
  int *color = data;

  PROCESS_BEGIN();

  while(1) 
  {
    PROCESS_WAIT_EVENT_UNTIL(ev == event1);

    printf("Process toggle\n");

    leds_toggle(*color);
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/

//                                PROCESS COLOR
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(color_process, ev, data)
{
  int *color = data;

  PROCESS_BEGIN();

  while(1) 
  {
    PROCESS_WAIT_EVENT_UNTIL(ev == event2);
    printf("Process color\n");

    switch (*color)
    {
    case LEDS_YELLOW:
        *color = LEDS_GREEN;
        leds_off(LEDS_ALL);
        break;
    case LEDS_GREEN:
        *color = LEDS_RED;
        leds_off(LEDS_ALL);
        break;
    case LEDS_RED:
        *color = LEDS_YELLOW;
        leds_off(LEDS_ALL);
        break;
    default:
        *color = LEDS_YELLOW;
        leds_off(LEDS_ALL);
        break;
    }

    printf("Color : %d\n", *color);
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/

