
/*
 * \file
 *         A very simple Contiki application
 * \author
 *         NUP, FSA
 */

#include "contiki.h"
#include "net/routing/routing.h"
#include "random.h"
#include "net/netstack.h"
#include "net/ipv6/simple-udp.h"
#include "sys/etimer.h"
#include "sys/log.h"



#include <stdio.h> 
#define UDP_CLIENT_PORT 8765
#define UDP_CLIENT_PORT 8765
#define LOG_LEVEL LOG_LEVEL_INFO
#define LOG_MODULE "App"
#define SEND_INTERVAL (10*CLOCK_SECOND)
/*---------------------------------------------------------------------------*/
PROCESS(udp_local_mcaste_process, "UDP LOCAL MULTICAST process");
AUTOSTART_PROCESSES(&udp_local_mcaste_process);
struct simple_udp_connection mcast_connection;



static void receiver(struct simple_udp_connection *c,
const uip_ipaddr_t *sender_addr,
uint16_t sender_port,
const uip_ipaddr_t *receiver_addr,
uint16_t receiver_port,
const uint8_t *data,
uint16_t datalen)
{
    printf("sender port : %d \n", sender_port);
    printf("Adresse : ");
    LOG_INFO_6ADDR(sender_addr);
    printf("\n");
}
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(udp_local_mcaste_process, ev, data)
{
  static struct etimer timer;
  static uint8_t id;
  uip_ipaddr_t addr;
  char str[32];

  PROCESS_BEGIN();

  /* Setup a periodic timer that expires after 2 seconds. */
  etimer_set(&timer, SEND_INTERVAL - CLOCK_SECOND + (random_rand() % (2*CLOCK_SECOND)) );

  simple_udp_register(&mcast_connection, UDP_CLIENT_PORT, NULL, UDP_CLIENT_PORT, receiver);
  

  while(1) 
  {
    LOG_INFO_("Sending request %u to ", id);
    uip_create_linklocal_allnodes_mcast(&addr);
    LOG_INFO_6ADDR(&addr);
    LOG_INFO_("\n");
    snprintf(str, sizeof(str), "This is %d", id);
    simple_udp_sendto(&mcast_connection, str, strlen(str), &addr);
    id++;
        /* Wait for the periodic timer to expire and then restart the timer. */
    PROCESS_WAIT_EVENT_UNTIL(etimer_expired(&timer));
    etimer_reset(&timer);
   
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/
