
/*
 * \file
 *         A very simple Contiki application
 * \author
 *         NUP, FSA
 */

#include "contiki.h"
#include "net/routing/routing.h"
#include "random.h"
#include "net/netstack.h"
#include "net/ipv6/simple-udp.h"
#include "net/ipv6/uip-ds6.h"
#include "sys/etimer.h"
#include "sys/log.h"
#include "string.h"



#include <stdio.h> 
#define UDP_CLIENT_PORT 8765
#define UDP_CLIENT_PORT 8765
#define LOG_LEVEL LOG_LEVEL_INFO
#define LOG_MODULE "App"
#define SEND_INTERVAL (10*CLOCK_SECOND)
static struct simple_udp_connection ucast_connection;
static void set_addr(uip_ipaddr_t * ipaddr)
{
    int i;
    uint8_t state;
    const uip_ipaddr_t* default_prefix = uip_ds6_default_prefix();

    uip_ip6addr_copy(ipaddr, default_prefix);
    uip_ds6_set_addr_iid(ipaddr, &uip_lladdr);
    uip_ds6_addr_add(ipaddr, 0 , ADDR_AUTOCONF);

    printf("IPV6 addresses: ");
    for (i=0; i < UIP_DS6_ADDR_NB; i++)
    {
        state= uip_ds6_if.addr_list[i].state;
        if(uip_ds6_if.addr_list[i].isused && (state == ADDR_TENTATIVE || state == ADDR_PREFERRED))
        {
            LOG_INFO_6ADDR(&uip_ds6_if.addr_list[i].ipaddr);
            *ipaddr = uip_ds6_if.addr_list[i].ipaddr;
            LOG_INFO("\n");
        }
    }

}
/*---------------------------------------------------------------------------*/
PROCESS(udp_local_ucaste_process, "UDP LOCAL MULTICAST process");
AUTOSTART_PROCESSES(&udp_local_ucaste_process);




static void receiver(struct simple_udp_connection *c,
const uip_ipaddr_t *sender_addr,
uint16_t sender_port,
const uip_ipaddr_t *receiver_addr,
uint16_t receiver_port,
const uint8_t *data,
uint16_t datalen)
{
    LOG_INFO("Reponse recu %.*s de \n",datalen,(char*)data);
    printf("sender port : %d \n", sender_port);
    printf("Adresse : ");
    LOG_INFO_6ADDR(sender_addr);
    printf("\n");
}
/*---------------------------------------------------------------------------*/
PROCESS_THREAD(udp_local_ucaste_process, ev, data)
{
  static struct etimer timer;
  static uint8_t id=0;
  uip_ipaddr_t addr;
  char str[32];

  PROCESS_BEGIN();

  set_addr(&addr);
  addr.u8[15]=0x02;
  /* Setup a periodic timer that expires after 2 seconds. */
  etimer_set(&timer, SEND_INTERVAL - CLOCK_SECOND + (random_rand() % (2*CLOCK_SECOND)) );

  simple_udp_register(&ucast_connection, UDP_CLIENT_PORT, NULL, UDP_CLIENT_PORT, receiver);
  

  while(1) 
  {
    LOG_INFO_("Sending request %u to ", id);
    uip_create_linklocal_allnodes_mcast(&addr);
    LOG_INFO_6ADDR(&addr);
    LOG_INFO_("\n");
    snprintf(str, sizeof(str), "This is request No %d", id);
    simple_udp_sendto(&ucast_connection, str, strlen(str), &addr);
    id++;
    /* Wait for the periodic timer to expire and then restart the timer. */
    PROCESS_WAIT_EVENT_UNTIL(etimer_expired(&timer));
    etimer_reset(&timer); 
  }

  PROCESS_END();
}
/*---------------------------------------------------------------------------*/
