package com.example.demo;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig extends WebSecurityConfigurerAdapter {
    @Override
    protected void configure(HttpSecurity http) throws Exception {
        http        
            .authorizeRequests()
                .antMatchers("/", "/home").permitAll()
                .antMatchers("/allMentor").permitAll()
                .antMatchers("/formMentor").permitAll()
                .antMatchers("/insertMentor").permitAll()
                .antMatchers("/allPoulain").permitAll()
                .antMatchers("/formPoulain").permitAll()
                .antMatchers("/insertPoulain").permitAll()
                .antMatchers("/allHelpRequest").permitAll()
                .antMatchers("/formHelpRequest").permitAll()
                .and()
            .formLogin()
                .loginPage("/login")
                .permitAll()
                .and()
            .logout()
                .permitAll();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth
                .inMemoryAuthentication()
                .withUser("mentor").password("{noop}mentor").roles("MENTOR")
                .and().withUser("poulain").password("{noop}poulain").roles("POULAIN");
    }
    
}