```
git clone https://github.com/rancavil/hadoop-single-node-cluster.git
cd hadoop-single-node-cluster
docker build -t hadoop .
docker run -name myhadoop -p 9864:9864 -p 9870:9870 -p 8088:8088 hadoop
docker exec -it myhadoop bash

hdfs dfs -mkdir /user
hdfs dfs -mkdir /user/hduser
hdfs dfs -ls
hdfs dfs -ls /user/hduser
hdfs dfs -mkdir input
hdfs dfs -ls /user/hduser

echo $HADOOP_HOME
hdfs dfs -put $HADOOP_HOME/etc/hadoop/*.xml input
hdfs dfs -ls /user/hduser/input

hadoop jar $HADOOP_HOME/share/hadoop/mapreduce/hadoop-mapreduce-examples-3.3.3.jar grep input output 'yarn'
hdfs dfs -ls output
hdfs dfs -cat output/*

hdfs dfs -rm input/* output/*
hdfs dfs -rmdir input output

cd examples
sudo apt install python

hdfs dfs -mkdir input
hdfs dfs -put *.txt input
hadoop jar $HADOOP_HOME/share/hadoop/tools/lib/hadoop-streaming-3.3.3.jar -mapper mapper.py -reducer reducer.py -input /user/hduser/input/*.txt -output /user/hduser/output
hdfs dfs -ls output
hdfs dfs -cat output/*
```